/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.RenderableTextComponent;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.BrewingStandTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import snownee.jade.JadePlugin;
import snownee.jade.Renderables;

public class BrewingStandProvider
implements IComponentProvider,
IServerDataProvider<TileEntity> {
    public static final BrewingStandProvider INSTANCE = new BrewingStandProvider();

    @Override
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (!config.get(JadePlugin.BREWING_STAND) || !accessor.getServerData().func_150297_b("BrewingStand", 10)) {
            return;
        }
        CompoundNBT tag = accessor.getServerData().func_74775_l("BrewingStand");
        int fuel = tag.func_74762_e("fuel");
        int time = tag.func_74762_e("time");
        RenderableTextComponent stack = Renderables.item(new ItemStack((IItemProvider)Items.field_151065_br), 0.75f, 0);
        RenderableTextComponent fuelText = Renderables.offsetText((ITextComponent)new TranslationTextComponent("jade.brewingStand.fuel", new Object[]{fuel}), 0, 3);
        if (time > 0) {
            tooltip.add((ITextComponent)Renderables.of(new ITextComponent[]{stack, fuelText, Renderables.spacer(5, 0), Renderables.item(new ItemStack((IItemProvider)Items.field_151113_aN), 0.75f, 0), Renderables.offsetText((ITextComponent)new TranslationTextComponent("jade.brewingStand.time", new Object[]{time / 20}), 0, 3)}));
        } else {
            tooltip.add((ITextComponent)Renderables.of(new ITextComponent[]{stack, fuelText}));
        }
    }

    @Override
    public void appendServerData(CompoundNBT tag, ServerPlayerEntity player, World arg2, TileEntity te) {
        if (te instanceof BrewingStandTileEntity) {
            BrewingStandTileEntity brewingStand = (BrewingStandTileEntity)te;
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("time", brewingStand.field_145946_k);
            compound.func_74768_a("fuel", brewingStand.field_184278_m);
            tag.func_218657_a("BrewingStand", (INBT)compound);
        }
    }
}

